<?php

require "MoodleClient.php";
$moodleClient = new MoodleClient;

$external_id = array();

$file = "formazione-categorie.tsv";
$fh = fopen($file, 'r');
while (($line = fgetcsv($fh, 0, "\t")) !== false) {
  if (!preg_match("/^#/", $line[0])) {

    // Parametri
    $name = $line[2];
    $cod = $line[0];
    $cod_parent = $line[1];
    if ($cod_parent == "NNN") {
      $parent = 0;
    } else {
      if (!empty($external_id[$cod_parent])) {
        $parent = $external_id[$cod_parent];
      } else {
print "category: external id error\n";
exit;
      }
    }

    // Inserimento
    $categoria = array(
      "name" => $name,
      "idnumber" => $code,
      "parent" => $parent,
    );
    $result = $moodleClient->createCategory($categoria);

    // ID categoria
    if (!empty($result[0]["id"])) {
      $external_id[$line[0]] = $result[0]["id"];
    } else {
print "category: internal id error\n";
exit;
    }

  }
}
fclose($fh);

$file = "formazione-corsi.tsv";
$fh = fopen($file, 'r');
while (($line = fgetcsv($fh, 0, "\t")) !== false) {
  if (!preg_match("/^#/", $line[0])) {

    // Parametri
    $cod_categoria = $line[0];
    $cod_corso = $line[1];
    $fullname = $line[3];
    $summary = $line[4];
    if (!empty($external_id[$cod_categoria])) {
      $categoryid = $external_id[$cod_categoria];
    } else {
print "course: internal category id error\n";
exit;
    }

    // Inserimento
    $corso = array(
      "fullname" => $fullname,
      "summary" => $summary,
      "categoryid" => $categoryid,
      "idnumber" => $cod_corso,
    );
    $result = $moodleClient->createCourse($corso);
  }
}
fclose($fh);

