<?php

class MoodleClient
{

    private static $domainName = "https://fad.seagruppoacademy.it";
    private static $token = "24f25085f31327b1da14ccc8d1b0029b";

    /**
     * category[name]= string
     * category[parent]= int
     * category[idnumber]= string
     */
    function createCategory($category) {
/*
        $query = "";
        foreach ($categories as $i => $category) {
            $query .= "categories[{$i}][name]=" . urlencode($category["name"]) . "&" .
                "categories[{$i}][idnumber]={$category["idnumber"]}&" .
                "categories[{$i}][parent]={$category["parent"]}&";
        }
        $query = rtrim($query, "&");
*/
        $query = "categories[0][name]=" . urlencode($category["name"]) . "&" .
            "categories[0][idnumber]={$category["idnumber"]}&" .
            "categories[0][parent]={$category["parent"]}";
        return $this->moodleRequest("core_course_create_categories", $query);
    }

    /**
     *
     */
    function createCourse($course) {
        $query = "courses[0][fullname]=" . urlencode($course["fullname"]) . "&" .
            "courses[0][shortname]=" . urlencode($course["fullname"]) . "&" .
            "courses[0][summary]=" . urlencode($course["summary"]) . "&" .
            "courses[0][categoryid]={$course["categoryid"]}&" .
            "courses[0][idnumber]={$course["idnumber"]}";
        return $this->moodleRequest("core_course_create_courses", $query);
    }

    function moodleRequest($functionName, $params) {
        $url = self::$domainName  . '/webservice/rest/server.php?wstoken=' . self::$token . '&moodlewsrestformat=json&wsfunction=' . $functionName;
        $options = array(
            "http" => array(
              "header"  => "Content-type: application/x-www-form-urlencoded\r\n",
              "method"  => "POST",
              "content" => $params
            )
        );
        $context = stream_context_create($options);
        $result = file_get_contents($url, false, $context);

// Log
print "<pre>datetime=" . date("Y-m-d h:i:s") . "\nfunction={$functionName}\nparams={$params}\nresult={$result}</pre>";

        return json_decode($result, true);
    }
}

